/*
 * Created on Aug 7, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package AppletInterface;

import amber.type.server.*;
import amber.server.panel.*;
import amber.server.component.*;
import amber.server.application.ApplicationInterface;
//import amber.server.exception.* ;
import amber.awt.event.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.*;

import DataClasses.*;
import Validators.*;
import XmlCommunication.*;
import DatabaseCommunication.*;

/**
  * This class handles the requirements for the specific manipulation of panels within
  * specific applications. In a lot of ways this class functions very similarly to the
  * ApplicationInterface class.
  * This is the overall intelligence for this particular panel.
  *
  * @author Insert your name here
  * @version 1.0.0
  * @see amber.server.panel.BaseFrame
*/
/**
 * @author student
 *
 * This class is being used for registering a new customer. This class does the
 * validation of data, sends adminadd and transaction auth to TMS and adds a new
 * customer to the application database.
 * 
 */
public class RegisterFrame
	extends BaseFrame
	implements ItemListener, ComponentWindowListener, ActionListener {
	private static int unique = 0;
	private Stock_Data[] stocks;

	private Stock_Data stock;
	private User_Data user;
	private CreditCard_Data creditcard;
	private UserAddress_Data address;

	private UserManager umanager = new UserManager();

	private ServletConnection servletconn = new ServletConnection();
	private XmlGenerator xmlgenerator = new XmlGenerator();
	private XmlUnmarshal xmlunmarshal = new XmlUnmarshal();

	private LoginFrame caller;

	public final int FRAMEWIDTH = 800;
	public final int FRAMEHEIGHT = 700;

	private String[] type =
		{ "{select type of user}", "Person", "Organisation" };
	private String[] creditCardTypes =
		{
			"{select credit card type}",
			"American Express",
			"Visa",
			"MasterCard" };
	//private String[] dateTypes = new String[31];
	private String[] monthTypes = new String[12];
	private String[] yearTypes =
		{ "2003", "2004", "2005", "2006", "2007", "2008", "2009", "2010" };

	private FloatButtonHandler btnMain =
		new FloatButtonHandler(getParentApplication());
	private ImageHandler imgBanner = new ImageHandler(getParentApplication());
	private FloatButtonHandler btnUpdate =
		new FloatButtonHandler(getParentApplication());
	private FloatButtonHandler btnLogin =
		new FloatButtonHandler(getParentApplication());
	private LabelHandler lblInfo = new LabelHandler(getParentApplication());
	private LabelHandler lblPersonOrganisation =
		new LabelHandler(getParentApplication());
	private LabelHandler lblFirstName =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtFirstName =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblLastName = new LabelHandler(getParentApplication());
	private TextFieldHandler txtLastName =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblOrganisation =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtOrganisation =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblPhoneNumber =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtPhone =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblEmail = new LabelHandler(getParentApplication());
	private TextFieldHandler txtEmail =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblPassword = new LabelHandler(getParentApplication());
	private TextFieldHandler txtPassword =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblVerifyPassword =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtVerifyPassword =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblCardDetails =
		new LabelHandler(getParentApplication());
	private LabelHandler lblCardType = new LabelHandler(getParentApplication());
	private ChoiceHandler chCardType =
		new ChoiceHandler(getParentApplication());
	private LabelHandler lblCardHolderName =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtHolderName =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblExpiryDate =
		new LabelHandler(getParentApplication());
	private LabelHandler lblUserName = new LabelHandler(getParentApplication());
	private TextFieldHandler txtUserName =
		new TextFieldHandler(getParentApplication());
	//private LabelHandler lblDate = new LabelHandler (getParentApplication ()) ;
	//private ChoiceHandler chDate = new ChoiceHandler (getParentApplication ()) ;
	private LabelHandler lblMonth = new LabelHandler(getParentApplication());
	private ChoiceHandler chMonth = new ChoiceHandler(getParentApplication());
	private LabelHandler lblYear = new LabelHandler(getParentApplication());
	private ChoiceHandler chYear = new ChoiceHandler(getParentApplication());
	private LabelHandler lblCardNumber =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtCardNumber =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblPreBilling =
		new LabelHandler(getParentApplication());
	private TextFieldHandler txtPreAuthorisation =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblContactAddress =
		new LabelHandler(getParentApplication());
	private LabelHandler lblStreet = new LabelHandler(getParentApplication());
	private TextFieldHandler txtStreet =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblSuburb = new LabelHandler(getParentApplication());
	private TextFieldHandler txtSuburb =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblCity = new LabelHandler(getParentApplication());
	private TextFieldHandler txtCity =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblCountry = new LabelHandler(getParentApplication());
	private TextFieldHandler txtCountry =
		new TextFieldHandler(getParentApplication());
	private LabelHandler lblStockPreferences =
		new LabelHandler(getParentApplication());
	private ListHandler lstStocks = new ListHandler(getParentApplication());
	private ButtonHandler btnAdd = new ButtonHandler(getParentApplication());
	private ButtonHandler btnRemove = new ButtonHandler(getParentApplication());
	private ChoiceHandler chInterested =
		new ChoiceHandler(getParentApplication());
	private LabelHandler lblInterestedStocks =
		new LabelHandler(getParentApplication());
	private FloatButtonHandler btnRegister =
		new FloatButtonHandler(getParentApplication());

	private Font level1 = new Font("Arial", Font.BOLD, 14);
	private Font level2 = new Font("Arial", Font.ITALIC, 14);
	private ChoiceHandler chType = new ChoiceHandler(getParentApplication());
	private LabelHandler lblType = new LabelHandler(getParentApplication());

	/**
	 * This is the constructor for RegisterFrame.java
	 */
	public RegisterFrame() {
		super();
		defineComponents();
	}

	/**
	  * The initialising constructor.
	  * @param appHandler The handle to the main ApplicationInterface which
	  * handles the functions of the overall application.
	*/
	public RegisterFrame(ApplicationInterface appHandler, LoginFrame caller) {
		super(appHandler);
		this.caller = caller;
		defineComponents();
	}

	/**
	  * The initialising constructor.
	  * @param id The int containing the id of the corresponding remote component
	  * residing on the browser.
	  * @param appHandler The handle to the main ApplicationInterface which
	  * handles the functions of the overall application.
	*/
	public RegisterFrame(int id, ApplicationInterface appHandler) {
		super(id, appHandler);
		defineComponents();
	}

	/**
		* This function would normally never need to be called, but is required
		* to be defined as it is called internally.
		* Its specific purpose is to set the controls to a known state once
		* they are created.
	*/
	public void fillControls() {
	}

	/**
	  * This function determines if the panel can be closed.
	  * The derived panels must determine if this panel can close. If this is
	  * not possible the function should return false.
	  * @return boolean false if it is not possible to close this panel.
	*/
	public boolean canClose() {
		return true;
	}

	/**
	  * This function is called to save any required information in the panel.
	  * This function is called externally when another panel wishes to take
	  * over the base panel or when closing the panel.
	  * This function need not actually do something.
	*/
	public void saveData() {
	}

	/**
	  * This function is called to define the components which are a part of this
	  * panel.
	  * This function is called by the constructor to set up the normal static
	  * components and their locations.
	  * This method is required.
	*/
	protected void defineComponents() {
		try {
			setProperties();
			addComponents();
			addListeners();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * This method is being used for setting properties for the components being
	 * used in this frame.
	 * @return void
	 */
	private void setProperties() {
		try {
			this.setTitle("Stock Trading Register");
			this.setBackground(Color.WHITE);
			imgBanner.setImage("Banner1.gif");

			btnMain.setBackground(Color.LIGHT_GRAY);
			btnUpdate.setBackground(Color.LIGHT_GRAY);
			btnLogin.setBackground(Color.LIGHT_GRAY);
			btnRegister.setBackground(Color.LIGHT_GRAY);

			lblPersonOrganisation.setFont(level1);
			lblContactAddress.setFont(level1);
			lblCardDetails.setFont(level1);
			lblStockPreferences.setFont(level1);
			lblInterestedStocks.setFont(level1);

			for (int i = 0; i < type.length; i++) {
				chType.add((String) type[i]);
			}

			for (int h = 0; h < creditCardTypes.length; h++) {
				chCardType.add((String) creditCardTypes[h]);
			}

			for (int month = 0; month < 12; month++) {
				if (month < 9)
					monthTypes[month] = "0" + (month + 1);
				else
					monthTypes[month] = "" + (month + 1);
			}

			for (int k = 0; k < monthTypes.length; k++) {
				chMonth.add((String) monthTypes[k]);
			}
			for (int l = 0; l < yearTypes.length; l++) {
				chYear.add((String) yearTypes[l]);
			}

			btnMain.setLabel("MAIN");
			btnUpdate.setLabel("UPDATE");
			btnLogin.setLabel("LOGIN");
			lblInfo.setText("");
			lblInfo.setFont(level1);
			lblPersonOrganisation.setText("Person/Organisation:");
			lblFirstName.setText("First Name :");
			txtFirstName.setText("");
			lblPersonOrganisation.setText("Person/Organisation Details :");
			lblLastName.setText("Last Name :");
			txtLastName.setText("");
			lblOrganisation.setText("Organisation :");
			txtOrganisation.setText("");
			lblPhoneNumber.setText("Phone Number :");
			txtPhone.setText("");
			lblEmail.setText("Email Address :");
			txtEmail.setText("");
			lblUserName.setText("User Name:");
			txtUserName.setText("");
			lblPassword.setText("Password :");
			txtPassword.setText("");
			lblVerifyPassword.setText("Verify Password :");
			txtVerifyPassword.setText("");
			lblCardDetails.setText("Credit Card Details :");
			lblCardType.setText("Card Type :");
			lblCardHolderName.setText("Holder Name :");
			txtHolderName.setText("");
			lblExpiryDate.setText("Expiry Date :");
			//lblDate.setText ("D:") ;
			lblMonth.setText("Month");
			lblYear.setText("Year");
			lblCardNumber.setText("Card Number :");
			txtCardNumber.setText("");
			lblPreBilling.setText("PreAuthorisation :");
			txtPreAuthorisation.setText("");
			lblContactAddress.setText("Contact Address :");
			lblStreet.setText("Street :");
			txtStreet.setText("");
			lblSuburb.setText("Suburb :");
			txtSuburb.setText("");
			lblCity.setText("City :");
			txtCity.setText("");
			lblCountry.setText("Country :");
			txtCountry.setText("");
			lblStockPreferences.setText("Listed Stock Options :");
			btnAdd.setLabel(">>");
			btnRemove.setLabel("<<");
			lblInterestedStocks.setText("Stocks interested in :");
			btnRegister.setLabel("REGISTER");

			btnMain.setEnabled(false);
			btnUpdate.setEnabled(false);
			lblSuburb.setText("Suburb :");
			lblType.setText("Register as :");

			txtPassword.setEchoChar('*');
			txtVerifyPassword.setEchoChar('*');

			stocks =
				((StockTradingApplication) this.getParentApplication())
					.getStocks();
			String[] display = new String[stocks.length];

			for (int d = 0; d < display.length; d++) {
				display[d] = ((Stock_Data) stocks[d]).toString();
			}
			for (int x = 0; x < display.length; x++)
				lstStocks.add((String) display[x]);
		} catch (Exception ex) {
			System.err.println(ex.toString());
		}
	}

	/**
	 * This method is being used for adding the components to the 3 panels. 
	 * @return void
	 */
	private void addComponents() {
		try {
			add(btnMain, new XYConstraints(164, 100, 154, 20));
			add(imgBanner, new XYConstraints(0, 0, 800, 100));
			add(btnUpdate, new XYConstraints(323, 100, 154, 20));
			add(btnLogin, new XYConstraints(482, 100, 154, 20));
			add(lblInfo, new XYConstraints(50, 588, 750, 20));
			add(lblPersonOrganisation, new XYConstraints(4, 124, 200, 20));
			add(lblFirstName, new XYConstraints(5, 200, 100, 20));
			add(txtFirstName, new XYConstraints(105, 200, 200, 20));
			add(lblLastName, new XYConstraints(5, 225, 100, 20));
			add(txtLastName, new XYConstraints(105, 225, 200, 20));
			add(lblOrganisation, new XYConstraints(4, 250, 100, 20));
			add(txtOrganisation, new XYConstraints(105, 250, 200, 20));
			add(lblPhoneNumber, new XYConstraints(5, 275, 100, 20));
			add(txtPhone, new XYConstraints(105, 275, 200, 20));
			add(lblEmail, new XYConstraints(5, 300, 100, 20));
			add(txtEmail, new XYConstraints(105, 300, 200, 20));
			add(lblUserName, new XYConstraints(5, 325, 100, 20));
			add(txtUserName, new XYConstraints(105, 325, 200, 20));
			add(lblPassword, new XYConstraints(5, 350, 100, 20));
			add(txtPassword, new XYConstraints(105, 350, 200, 20));
			add(lblVerifyPassword, new XYConstraints(5, 375, 100, 20));
			add(txtVerifyPassword, new XYConstraints(104, 375, 200, 20));
			add(lblCardDetails, new XYConstraints(5, 420, 200, 20));
			add(lblCardHolderName, new XYConstraints(5, 450, 100, 20));
			add(txtHolderName, new XYConstraints(105, 450, 200, 20));
			add(lblCardNumber, new XYConstraints(5, 475, 100, 20));
			add(txtCardNumber, new XYConstraints(105, 475, 200, 20));
			add(lblCardType, new XYConstraints(5, 500, 100, 20));
			add(chCardType, new XYConstraints(105, 500, 200, 21));
			add(lblExpiryDate, new XYConstraints(5, 525, 100, 20));
			add(lblMonth, new XYConstraints(105, 525, 50, 20));
			add(chMonth, new XYConstraints(155, 525, 40, 21));
			add(lblYear, new XYConstraints(195, 525, 50, 20));
			add(chYear, new XYConstraints(245, 525, 60, 21));
			add(lblPreBilling, new XYConstraints(5, 550, 100, 20));
			add(txtPreAuthorisation, new XYConstraints(105, 550, 200, 20));
			add(lblContactAddress, new XYConstraints(400, 125, 200, 20));
			add(lblStreet, new XYConstraints(400, 150, 100, 20));
			add(txtStreet, new XYConstraints(500, 150, 200, 20));
			add(lblSuburb, new XYConstraints(400, 175, 100, 20));
			add(txtSuburb, new XYConstraints(500, 175, 200, 20));
			add(lblCity, new XYConstraints(400, 200, 100, 20));
			add(txtCity, new XYConstraints(500, 200, 200, 20));
			add(lblCountry, new XYConstraints(400, 225, 100, 20));
			add(txtCountry, new XYConstraints(500, 225, 200, 20));
			add(lblStockPreferences, new XYConstraints(400, 350, 200, 20));
			add(lstStocks, new XYConstraints(400, 375, 164, 120));
			add(btnAdd, new XYConstraints(580, 370, 50, 60));
			add(btnRemove, new XYConstraints(580, 435, 50, 60));
			add(chInterested, new XYConstraints(642, 420, 140, 20));
			add(lblInterestedStocks, new XYConstraints(652, 348, 128, 20));
			add(btnRegister, new XYConstraints(400, 550, 154, 20));
			add(chType, new XYConstraints(105, 160, 200, 21));
			add(lblType, new XYConstraints(5, 160, 100, 20));
		} catch (Exception ex) {
			System.err.println(ex.toString());
		}
	}
	/**
	 * This method is being used for adding listeners to the components that are
	 * being used in this frame.
	 * @return void
	 */
	private void addListeners() {
		try {
			btnRegister.addActionListener(this);
			btnLogin.addActionListener(this);
			chType.addItemListener(this);
			btnAdd.addActionListener(this);
			btnRemove.addActionListener(this);

			addItemListener(this);
			addWindowListener(this);
			addActionListener(this);
		} catch (Exception ex) {
			System.err.println(ex.toString());
		}
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			if (e.getSource() == btnRegister) {

				if (chType.getSelectedItem().equals("{select type of user}"))
					throw new ValidationException("You need to select a type to register as.");

				//user validation..+++++++++++++++++++++++++++++

				String type = chType.getSelectedItem();
				String firstName = txtFirstName.getText();
				String lastName = txtLastName.getText();
				String organisation = txtOrganisation.getText();
				String username = txtUserName.getText();
				String password = txtPassword.getText();
				String verifier = txtVerifyPassword.getText();
				String pre = txtPreAuthorisation.getText();
				String acc = txtPreAuthorisation.getText();

				if (type.equals("Person")) {
					if (firstName.equals("")
						|| lastName.equals("")
						|| username.equals("")
						|| password.equals("")
						|| verifier.equals(""))
						throw new ValidationException("Required User detail fields are empty.");
				} else {
					if (organisation.equals("")
						|| username.equals("")
						|| password.equals("")
						|| verifier.equals(""))
						throw new ValidationException("Required User detail fields are empty.");
				}

				String[] interests = chInterested.getItems();
				Stock_Data[] interested = getStocks(interests);

				user =
					new User_Data(
						type,
						firstName,
						lastName,
						organisation,
						username,
						password,
						verifier,
						pre,
						acc,
						interested);

				UserValidator uv = new UserValidator();
				boolean userValid = uv.validate(user);

				if (!userValid) {
					throw new ValidationException(uv.getMessage());
				}

				if (pre.equals(""))
					throw new ValidationException("Prebilling amount field is empty.");
				if (!isNumber(acc))
					throw new ValidationException("PreBilling amount field must contain a number (without a . or $).");

				AccountValidator av = new AccountValidator();
				boolean accValid = av.validate(user);

				if (!accValid) {
					throw new ValidationException(av.getMessage());
				}

				//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				//New login validation+++++++++++++++++++++++++++++++++++++++++++++++

				NewLoginValidator nlv = new NewLoginValidator();
				boolean newLoginValid = nlv.validate(user);

				if (!newLoginValid) {
					throw new ValidationException(nlv.getMessage());

				}

				//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				//Stocks Interested validation++++++++++++++++++++++++++++++++++++

				if (chInterested.getItemCount() <= 0)
					throw new ValidationException("You have to choose at least one stock as interested.");

				//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				//UserAddress Validation+++++++++++++++++++++++++++++++++++++++++++++

				String email = txtEmail.getText();
				String street = txtStreet.getText();
				String suburb = txtSuburb.getText();
				String city = txtCity.getText();
				String country = txtCountry.getText();
				String phone = txtPhone.getText();

				if (email.equals("")
					|| street.equals("")
					|| suburb.equals("")
					|| city.equals("")
					|| country.equals("")
					|| phone.equals(""))
					throw new ValidationException("Required Address detail fields are empty.");

				address =
					new UserAddress_Data(
						email,
						street,
						suburb,
						city,
						country,
						phone);

				UserAddressValidator uav = new UserAddressValidator();
				boolean addressValid = uav.validate(address);

				if (!addressValid) {
					throw new ValidationException(uav.getMessage());

				}

				//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				//Credit card Validation..++++++++++++++++++++++++++++++++++++++++

				String cardType = chCardType.getSelectedItem();
				String holderName = txtHolderName.getText();
				String cardNumber = txtCardNumber.getText();
				String month = chMonth.getSelectedItem();
				String year =
					((String) chYear.getSelectedItem()).substring(2, 4);
				String expiry = month + year;
				System.out.println("Expiry Date: " + expiry);

				if (cardType.equals("")
					|| holderName.equals("")
					|| cardNumber.equals("")
					|| expiry.equals(""))
					throw new ValidationException("Required Credit card detail fields are empty.");

				creditcard =
					new CreditCard_Data(
						cardType,
						holderName,
						cardNumber,
						expiry);

				CreditCardValidator ccv = new CreditCardValidator();
				boolean creditCardValid = ccv.validate(creditcard);

				if (!creditCardValid) {
					throw new ValidationException(ccv.getMessage());
				}

				//End of validation++++++++++++++++++++++++++++++++++++++++++++++++

				//adding ncb logic calls goes here..

				//form xml message..
				String xmlstr = xmlgenerator.adminAddXml(user, address);
				System.out.println("ADMIN ADD XML: " + xmlstr);

				//send and get xml message to/from TMS
				String res = servletconn.sendXml(xmlstr);
				System.out.println("RESPONSE: " + res);

				//interpret xml message from TMS
				String message = xmlunmarshal.readResponse(res);

				int responseCode =
					Integer.parseInt(xmlunmarshal.getResponseGeneralCode());
				System.out.println("+++CODE+++: " + responseCode);

				if (responseCode > 0)
					throw new ValidationException(message);
				//				  	
				//				interpret xml message from TMS..
				//     			  setMessage(XmlUnmarshal.readResponse(out));

				int id = xmlunmarshal.getNcbId();

				if (id != 0) {
					String todisplay = "";

					user.setNcbId(id);

					//form xml message for auth.
					String xmlauthstr =
						xmlgenerator.transactionAuthXml(user, creditcard);
					System.out.println("TRANSACTION AUTH XML: " + xmlauthstr);

					//send and get xml message to/from TMS..
					String outauth = servletconn.sendXml(xmlauthstr);
					System.out.println("RESPONSE: " + outauth);

					//interpret xml message from TMS..
					xmlunmarshal.readResponse(outauth);

					todisplay += "Your Details have been added to TMS. ";
					todisplay += "Your user name is: "
						+ user.getUserName()
						+ ". ";
					todisplay += "Please retain your user name to login.";

					lblInfo.setText(todisplay);
					btnRegister.setEnabled(false);

					//now add user to the local database..
					boolean done = umanager.insertUser(user);

					System.out.println(
						"Inserted user into local database successfully: "
							+ done);

				}
			} else if (e.getSource() == btnLogin) {
				//Go back to the login screen.
				setVisible(false);
				caller.setVisible(true);
			} else if (e.getSource() == btnAdd) {
				//add stock to the graph.
				if (lstStocks.getSelectedIndex() != -1) {
					String transfer = lstStocks.getSelectedItem();
					int index = lstStocks.getSelectedIndex();
					lstStocks.remove(index);
					chInterested.add(transfer);
				}

			} else if (e.getSource() == btnRemove) {
				//remove stock from the graph.
				if (chInterested.getSelectedIndex() != -1) {
					String transfer = chInterested.getSelectedItem();
					int index = chInterested.getSelectedIndex();
					chInterested.remove(index);
					lstStocks.add(transfer);
				}

			}

		} catch (Exception ex) {

			ex.printStackTrace();
			displayMessageBox("Error", ex.getMessage());
		}

	}
	/* (non-Javadoc)
	 * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
	 */
	public void itemStateChanged(ItemEvent ie) {
		try {
			System.out.println("hello");
			if (chType.getSelectedItem().equals("{select a type}")) {
				lblInfo.setText("You need to select a type to register as.");
			} else if (chType.getSelectedItem().equals("Organisation")) {
				System.out.println("You have selected organisation.");
				txtFirstName.setEnabled(false);
				txtLastName.setEnabled(false);
				txtFirstName.setBackground(Color.LIGHT_GRAY);
				txtLastName.setBackground(Color.LIGHT_GRAY);
				txtOrganisation.setEnabled(true);
				txtOrganisation.setBackground(Color.WHITE);
			} else if (chType.getSelectedItem().equals("Person")) {
				System.out.println("You have selected person.");
				txtOrganisation.setEnabled(false);
				txtOrganisation.setBackground(Color.LIGHT_GRAY);
				txtFirstName.setEnabled(true);
				txtLastName.setEnabled(true);
				txtFirstName.setBackground(Color.WHITE);
				txtLastName.setBackground(Color.WHITE);
			}
		} catch (Exception ex) {
			System.out.println("Exception : " + ex.toString());
		}

	}
	/**
	 * This utility method is being used for getting the stocks details based
	 * on the given names.
	 * @param names The names of the stocks for which information is to be
	 * retrieved.
	 * @return Stock_Data[] The stocks' details that are retrieved.
	 */
	private Stock_Data[] getStocks(String[] names) {
		Stock_Data[] interests = new Stock_Data[names.length];
		int count = 0;
		for (int f = 0; f < names.length; f++) {
			for (int g = 0; g < stocks.length; g++) {
				Stock_Data temp = (Stock_Data) stocks[g];
				if (((String) names[f]).equals(temp.toString())) {
					interests[count] = temp;
					System.out.println(temp.toString());
					count++;
					break;
				}
			}
		}
		return interests;
	}

	/**
	 * This utility method is being used for checking whether a string represents
	 * a number.
	 * @param s The string that is to be checked.
	 * @return boolean Specifies whether the string is a number.
	 */
	private boolean isNumber(String s) {
		for (int j = 0; j < s.length(); j++) {
			if (!Character.isDigit(s.charAt(j))) {
				return false;
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowOpened(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowOpened(ComponentWindowEvent arg0) {
	}
	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowClosing(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowClosing(ComponentWindowEvent arg0) {
		setVisible(false);
	}
	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowClosed(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowClosed(ComponentWindowEvent arg0) {
	}
	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowIconified(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowIconified(ComponentWindowEvent arg0) {
	}
	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowDeiconified(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowDeiconified(ComponentWindowEvent arg0) {
	}
	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowActivated(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowActivated(ComponentWindowEvent arg0) {
	}
	/* (non-Javadoc)
	 * @see amber.awt.event.ComponentWindowListener#windowDeactivated(amber.awt.event.ComponentWindowEvent)
	 */
	public void windowDeactivated(ComponentWindowEvent arg0) {
	}
}